#!/bin/bash

# 清理终端屏幕，让界面更干净
clear

echo "--------------------------------------------------"
echo "🚀 正在检查 Python 虚拟环境..."

# 检查 venv 文件夹是否存在
if [ -d "venv" ]; then
  echo "✅ 虚拟环境已存在。"
else
  echo "⚠️  虚拟环境不存在，正在为您创建..."
  # 使用 python3 创建虚拟环境
  python3 -m venv venv
  
  echo "⚙️  正在激活环境并安装所需依赖库..."
  # 激活虚拟环境
  source venv/bin/activate
  
  # 从 requirements.txt 文件安装依赖
  pip3 install -r requirements.txt
  
  # 直接跳转到运行脚本的步骤
  echo "✅ 依赖安装完成！"
fi

echo "⚙️  正在激活虚拟环境..."
# 激活虚拟环境 (对于已存在的情况)
source venv/bin/activate

echo "🐍 准备运行 Python 转换脚本..."
echo "--------------------------------------------------"

# 运行我们的交互式Python脚本
python3 raw_converter.py # 注意这里是脚本的文件名

echo "--------------------------------------------------"
echo "脚本执行完毕！"